﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;
using Newtonsoft.Json;

namespace DeXGets
{

    public class GroupDefinition : BaseClass
    {
        public class PastoralGroupDefintion_Response
        {
            public Guid ExternalID;
            public string ShortName;
        }
        private string GroupType;
        private string Service = "PastoralGroup";

        public void SetGroupType(string _GroupType)
        {
            GroupType = _GroupType;
        }
        protected string URL
        {
            get
            {
                string call = string.Format("PastoralGroupDefinitions?$filter=PastoralGroupType eq '{0}'&$select=ExternalID,ShortName&", GroupType);
                string URL_PGS = SetURL("PastoralGroups", call);

                return SetURL(Service, call);
            }
        }
        public Dictionary<Guid, PastoralGroupDefintion_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, PastoralGroupDefintion_Response> values = new Dictionary<Guid, PastoralGroupDefintion_Response>();
            string resp = DoCall(URL, token, httpClient, key);
            ODataResponse<PastoralGroupDefintion_Response> lookups = null;
            try
            {
                lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<PastoralGroupDefintion_Response>>(resp);
                foreach (PastoralGroupDefintion_Response s in lookups.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very unlikely  > 1000
                while (!string.IsNullOrEmpty(lookups.NextLink))
                {
                    resp = DoCall(GetNextLink(lookups.NextLink), token, httpClient, key);
                    lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<PastoralGroupDefintion_Response>>(resp);
                    foreach (PastoralGroupDefintion_Response s in lookups.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
